function [fdTrqOut, brakeUnfeas, brkProf] = brakeModel(brakeCmd, wheelTrq)

brakeTrq = brakeCmd .* 2.4e4;
wheelTrq = wheelTrq .* ones(size(brakeTrq));
fdTrqOut = wheelTrq + brakeTrq;

% Constraints
% Do not allow braking if there is a positive traction demand at the wheels
brakeUnfeas = wheelTrq > 0 & brakeCmd > 0;

%% Pack profiles
brkProf.brakeCmd = brakeCmd;
brkProf.brakeTrq = brakeTrq;
brkProf.brakeUnfeas = brakeUnfeas;

end